#import "SMPController.h"
#import "LeftDataSource.h"
#import "rightDataSource.h"

NSString *SMPUpKey=@"SMPUpKey";//[NSString stringWithFormat:@"%c", 0xF700];
NSString *SMPDownKey=@"SMPDownKey";//[NSString stringWithFormat:@"%c", 0xF701];
NSString *SMPLeftKey=@"SMPLeftKey";//[NSString stringWithFormat:@"%c", 0xF702];
NSString *SMPRightKey=@"SMPRightKey";//[NSString stringWithFormat:@"%c", 0xF703];
NSString *SMPReturnKey=@"SMPReturnKey";
NSString *SMPDeleteKey=@"SMPDeleteKey";
NSString *SMPEnterKey=@"SMPEnterKey";

@implementation SMPController

- (IBAction)list:(id)sender
{


}

-(void)refreshFolderList
{
	if (foldersList != nil)
		[foldersList release];
	foldersList = [[[NSFileManager defaultManager] directoryContentsAtPath:currentDir] retain]; 
	[foldersList removeObject:@".DS_Store"];
	[self refreshFolderSubList];
}
-(void)refreshFileList
{
	if (filesList != nil)
		[filesList release];
	NSArray *tempFileList = [[[NSFileManager defaultManager] subpathsAtPath:defaultPath] retain];
	searchString = [searchText stringValue];
	filesList = [self grep:searchString inArray:tempFileList]; 
	[filesList removeObject:@".DS_Store"];
	[self refreshFileSubList];
}

-(void)refreshFolderSubList
{
	int minItem = currentItem1-7;
	int rangeSize = 15;
	if (filesSubList != nil)
		[filesSubList release];
	if ((minItem + 15) > [foldersList count]) minItem = [foldersList count]-15;
	if (minItem < 1) minItem = 0; 
	if ((minItem + rangeSize) > [foldersList count]) rangeSize = [foldersList count] - minItem;
	if (currentItem1 < minItem) currentItem1=minItem;
	if (currentItem1 > (minItem + rangeSize)) currentItem1 = minItem + rangeSize;
	filesSubList = [[foldersList subarrayWithRange:NSMakeRange(minItem,rangeSize)] retain];
	[foldersView selectRowIndexes:[NSIndexSet indexSetWithIndex:currentItem1-minItem] byExtendingSelection:NO];
	[foldersView reloadData];
}


-(void)refreshFileSubList
{
	int minItem = currentItem2-7;
	int rangeSize = 13;
	if (filesSubList != nil)
		[filesSubList release];
	if ((minItem + 13) > [filesList count]) minItem = [filesList count]-13;
	if (minItem < 1) minItem = 0; 
	if ((minItem + rangeSize) > [filesList count]) rangeSize = [filesList count] - minItem;
	if (currentItem2 < minItem) currentItem2=minItem;
	if (currentItem2 > (minItem + rangeSize)) currentItem2 = minItem + rangeSize;
	//NSLog(@"minItem:%d,rangeSize:%d,currentItem:%d,filesList count:%d", minItem, rangeSize, currentItem, [filesList count]); 
	filesSubList = [[filesList subarrayWithRange:NSMakeRange(minItem, rangeSize)] retain];
	[filesView selectRowIndexes:[NSIndexSet indexSetWithIndex:currentItem2-minItem] byExtendingSelection:NO];
	[filesView reloadData];
}

-(id) init {
	if (self = [super init])
	{
		NSString *path = @"~/Music/mp3/";
		defaultPath = [[path stringByExpandingTildeInPath] retain];
		currentDir = defaultPath;
		[currentDir retain];
		currentItem = 0;
		currentItem1=0;
		currentItem2=0;
		currentPlaylistFolder=0;
		playlist = [[NSMutableArray alloc] init];
		inLeft=YES;
		isPaused=NO;
		isPlaying=NO;
		volume = 0.6;
		playMode=0;
		modeArray = [[NSArray  arrayWithObjects:@"(M): Normal", @"(M): Loop", @"(M): Random Folders", @"(M): Random", nil] retain];
		searchText=@"";
		typing=NO;
		
		//SettingUpTheNSMovieView
		player = [[NSMovieView alloc] init];
		[player setLoopMode:NSQTMovieNormalPlayback];
		[player setVolume:volume];
		[player showController:NO adjustingSize:NO];
		[player setEditable:NO];
	}
	return self;
}

-(int)currentPlaylistFolder
{
	return currentPlaylistFolder;
}

-(int)currentItem
{
	return currentItem;
}

-(void)setCurrentPlaylistFolder:(int)i
{
	currentPlaylistFolder=i;
}
-(void)setCurrentItem:(int)i
{
	currentItem=i;
}

-(void) dealloc {
	if (foldersList != nil)
		[foldersList release];
	if (filesList != nil)
		[filesList release];	
	if (filesSubList != nil)
		[filesSubList release];	

	[currentDir release];
	[defaultPath release];
	[playlist release];
	[modeArray release];
	[super dealloc];
}

-(BOOL)acceptsFirstResponder
{
return YES;
}


-(BOOL)resignFirstResponder
{
return NO;
}


-(void)awakeFromNib
{
		selectedTab=1;
		[tabView selectTabViewItemAtIndex:selectedTab];
		[self refreshFolderList];
		
		//fontSize
		//[playlistViewRight setFont:[NSFont systemFontOfSize:6]];

}

-(void)playSongWithPath:(NSString *)path
{
	long Movie_Length;
	long Movie_Time_Scale;
	[self stopSong];
	song = [[NSMovie alloc] initWithURL:[NSURL fileURLWithPath:path] byReference:NO];
	[player setMovie:song];
	[player gotoBeginning:self];
	[player start:self];
	[player setVolume:volume];
	Movie_Length = floor(GetMovieDuration( [song QTMovie] ));
	Movie_Time_Scale = floor(GetMovieTimeScale( [song QTMovie]));
	statusTimer = [NSTimer scheduledTimerWithTimeInterval:Movie_Length/Movie_Time_Scale target:self selector:@selector(checkStatus:) userInfo:nil repeats:NO];
	isPlaying=YES;
}

-(void)checkStatus:(NSTimer *)theTimer
{
	[self nextSong];
}

-(void)stopSong
{
	if ((statusTimer != nil) && ([statusTimer isValid])){
		[statusTimer invalidate];
		statusTimer=nil;
	}
	if (song != nil) {
		[player stop:self];
		[song release];
		song = nil;
	}
	isPlaying=NO;
}

-(void)jumpToSong:(int)j{
	currentItem=0;
	currentPlaylistFolder=0;
	//NSLog(@"j: %d",j);
	while (j>0) {
		NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
		if ([theArray count] <= j) {
			j=j-[theArray count];
			currentPlaylistFolder++;
		} else {
			//NSLog(@"j: %d",j);
			currentItem=j;
			j=0;
		}
		//NSLog(@"j: %d",j);
	}
	NSLog(@"Folder:%d Item:%d",currentPlaylistFolder, currentItem);
	NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
	[leftData refreshSubList];
	[rightData refreshSubList];
	[self playSongWithPath:[theArray objectAtIndex:currentItem]];
}

-(void)nextSong
{
	[self stopSong];
	if (playMode == 3) {
		int totalSongs=0;
		NSEnumerator *enumerator = [playlist objectEnumerator];
		PlaylistEntry *object;
		while (object = [enumerator nextObject]){
			NSMutableArray *theArray = [object filelist];
			totalSongs = totalSongs + [theArray count];
		}
		[self jumpToSong:random()%totalSongs];
	
	} else {
		NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
		if (currentItem < [theArray count]-1) {
			currentItem++;
			[rightData refreshSubList];
			[self playSongWithPath:[theArray objectAtIndex:currentItem]]; 
		} else if ((currentPlaylistFolder < [playlist count]-1) || (playMode==2)) {
			currentItem=0;
			if (playMode ==2 )
				currentPlaylistFolder=random()%[playlist count];
			else 
				currentPlaylistFolder++;
			[leftData refreshSubList];
			[rightData refreshSubList];
			theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
			[self playSongWithPath:[theArray objectAtIndex:currentItem]];  
		} else if ((currentPlaylistFolder >= [playlist count]-1) && (playMode==1)) {
			currentItem=0;
			currentPlaylistFolder=0;
			[leftData refreshSubList];
			[rightData refreshSubList];
			theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
		}
	}
}

-(void)pauseSong
{

	if (isPlaying) {
		if ((statusTimer != nil) && ([statusTimer isValid])){
			remainingTime=[[statusTimer fireDate] timeIntervalSinceNow];
			[statusTimer invalidate];
			statusTimer=nil;
		}
		isPaused=YES;
		isPlaying=NO;
		[player stop:self];
	}
}

-(void)continueSong
{
	if (isPlaying) 
		NSLog(@"AlreadyPlaying");
	else if (isPaused) {
		[player start:self];
		statusTimer = [NSTimer scheduledTimerWithTimeInterval:remainingTime target:self selector:@selector(checkStatus:) userInfo:nil repeats:NO];
		isPaused=NO;
	} else {
		NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
		[self playSongWithPath:[theArray objectAtIndex:currentItem]];  
	}
	isPlaying=YES;
}

-(void)prevSong
{
	[self stopSong];
	NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
	if (currentItem >0) {
		currentItem--;
		[rightData refreshSubList];
		[self playSongWithPath:[theArray objectAtIndex:currentItem]]; 
	} else if (currentPlaylistFolder > 0) {
		currentPlaylistFolder--;
		[leftData refreshSubList];
		theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
		currentItem=[theArray count]-1;
		[rightData refreshSubList];
		[self playSongWithPath:[theArray objectAtIndex:currentItem]];  
	}
}


-(NSString*)keyNameFromChar:(unichar)theChar
{
	if (theChar == 0xF700)
        return SMPUpKey;
	if (theChar == 0xF701)
        return SMPDownKey;
	if (theChar == 0xF702)
        return SMPLeftKey;
	if (theChar == 0xF703)
        return SMPRightKey;

	if (theChar >= 'a' && theChar <= 'z')
        return [NSString stringWithFormat:@"%c", theChar-32];
		
	if (theChar >= 'A' && theChar <= 'Z')
        return [NSString stringWithFormat:@"%c", theChar];
		
	if (theChar >= '0' && theChar <= '9')
        return [NSString stringWithFormat:@"%c", theChar];
    if (theChar == ' ')
        return @" ";
	if (theChar == ';')
        return @";";
	if (theChar == '[')
        return @"[";
	if (theChar == ']')
        return @"]";
	if (theChar == '\\')
        return @"\\";
	if (theChar == 13)
		return SMPReturnKey;
	if (theChar == 127)
		return SMPDeleteKey;
	if (theChar == '\'')
		return @"\'";
	if (theChar == 3)
		return SMPEnterKey;
	return @"";
}

- (void)keyDown:(NSEvent *)theEvent
{
    NSString *allChars = [theEvent charactersIgnoringModifiers];
	NSString *debugString;
    int i, howMany = [allChars length];
    for (i = 0; i < howMany; i++)
    {
		//if (![theEvent isARepeat]) {
			debugString = [self keyNameFromChar:[allChars characterAtIndex:i]];
			if (typing) 
				[self typeKey:debugString];
			else
				[self handleKey:debugString];
		//} 
	}
}

-(void)typeKey:(NSString *)key
{
	if ([key isEqual:SMPReturnKey]) {
		typing=NO;
		[searchText setBackgroundColor:[NSColor lightGrayColor]];
		[filesView setBackgroundColor:[NSColor whiteColor]];
		[self refreshFileList];
	} else {
		searchString = [NSString stringWithFormat:@"%@%@", searchString, key];
		[searchText setStringValue:searchString];
	}
}

-(void)handleKey:(NSString *)key
{
	if ([key isEqual:@"["]){
		selectedTab=0;
		[tabView selectTabViewItemAtIndex:selectedTab];
		[leftData refreshSubList];
		[rightData refreshSubList];
	}
	if ([key isEqual:@"]"]){
		selectedTab=1;
		[tabView selectTabViewItemAtIndex:selectedTab];
		[self refreshFolderList];
	}	
	if ([key isEqual:@"\\"]){
		selectedTab=2;
		[tabView selectTabViewItemAtIndex:selectedTab];
		[self refreshFileList];
	}
	if ([key isEqual:@"B"]){
		[self nextSong];
	}
	if ([key isEqual:@"Z"]){
		[self prevSong];
	}
	if ([key isEqual:@"X"]){
		[self continueSong];
	}
	if ([key isEqual:@"C"]){
		[self pauseSong];
	}
	if ([key isEqual:@"V"]){
		[self stopSong];
	}
	
	if ([key isEqual:@"Q"]){
		volume=volume+0.02;
		if (volume > 1)
			volume =1;
		[player setVolume:volume];
		[volumeText setStringValue:[NSString stringWithFormat:@"Volume: %1.2f", volume]];
	}
	if ([key isEqual:@"A"]){
		volume=volume-0.02;
		if (volume < 0)
			volume =0;
		[player setVolume:volume];
		[volumeText setStringValue:[NSString stringWithFormat:@"Volume: %1.2f", volume]];
	}
	
	
	if ([key isEqual:@"H"]){
		[helpDrawer toggle:self];
	}
	
	if([key isEqual:@"M"]){
		playMode = (playMode +1) % [modeArray count];
		[modeText setStringValue:[modeArray objectAtIndex:playMode]];
	}
	if ([key isEqual:@"G"]){
		if (selectedTab == 2){
			typing=YES;
			[searchText setBackgroundColor:[NSColor whiteColor]];
			[filesView setBackgroundColor:[NSColor lightGrayColor]];
			searchString = [NSString stringWithFormat:@"", searchString, key];
			[searchText setStringValue:searchString];
		}
	}
	
	if ([key isEqual:@"T"])
	{
		[self stopSong];
		currentPlaylistFolder=0;
		currentItem=0;
		[leftData refreshSubList];
		[rightData refreshSubList];
		NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
		[self playSongWithPath:[theArray objectAtIndex:currentItem]];
	}
	
	if ([key isEqual:@"R"])
	{
		[self stopSong];
		currentPlaylistFolder=random()%[playlist count];;
		[leftData refreshSubList];
		[rightData refreshSubList];
		NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
		currentItem=0;
		[self playSongWithPath:[theArray objectAtIndex:currentItem]];
	}
	
	if ([key isEqual:SMPDownKey]){
		if (selectedTab==0){
			if (inLeft) {
				currentPlaylistFolder++;
				currentItem=0;
				[leftData refreshSubList];
				[rightData refreshSubList];
			} else {
				currentItem++;
				[rightData refreshSubList];
			}
		}
		if (selectedTab==1){
			currentItem1++;
			[self refreshFolderSubList];
		}
		if (selectedTab ==2){
			currentItem2++;
			[self refreshFileSubList];
		}
	}
	if ([key isEqual:SMPUpKey]){
		if (selectedTab==0){
			if (inLeft) {
				currentPlaylistFolder--;
				currentItem=0;
				[leftData refreshSubList];
				[rightData refreshSubList];
			} else {
				currentItem--;
				[rightData refreshSubList];
			}
		}
		if (selectedTab==1){
			currentItem1--;
			[self refreshFolderSubList];
		}
		if (selectedTab ==2){
			currentItem2--;
			[self refreshFileSubList];
		}
	}
	
	//Right Arrow Key
	if ([key isEqual:SMPRightKey]) {
		if (selectedTab == 0) {
			inLeft=NO;
			[playlistViewLeft setBackgroundColor:[NSColor lightGrayColor]];
			[playlistViewRight setBackgroundColor:[NSColor whiteColor]];
		}
		if ((selectedTab==1)) {
			BOOL isDir;
			NSString *absolutePathToSelection = [NSString stringWithFormat:@"%@/%@", currentDir,[filesSubList objectAtIndex:[foldersView selectedRow]]];
			currentItem1=0;
			if ([[NSFileManager defaultManager] fileExistsAtPath:absolutePathToSelection isDirectory:&isDir]) {
				if (isDir) {
					[currentDir release];
					currentDir=[absolutePathToSelection retain];
					[self refreshFolderList];
				} else {
					//[self addFileToPlaylist:absolutePathToSelection];
				}
			}
		} else if (selectedTab == 2) {
			/*BOOL isDir;
			NSString *absolutePathToSelection = [NSString stringWithFormat:@"%@/%@", currentDir,[filesSubList objectAtIndex:[filesView selectedRow]]];
			if ([[NSFileManager defaultManager] fileExistsAtPath:absolutePathToSelection isDirectory:&isDir]) {
				if (isDir) {
					[self addFolderToPlaylist:absolutePathToSelection];
				} else {
					[self addFileToPlaylist:absolutePathToSelection];
				}
			}*/
		}
	}
	
	//Left Arrow Key
	if ([key isEqual:SMPLeftKey]) {
		if (selectedTab == 0) {
			inLeft=YES;
			[playlistViewLeft setBackgroundColor:[NSColor whiteColor]];
			[playlistViewRight setBackgroundColor:[NSColor lightGrayColor]];
		}
		if (selectedTab == 1) {
			if (![currentDir isEqual:defaultPath]) {
				currentItem1=0;
				NSString *absolutePathToParent = [currentDir stringByDeletingLastPathComponent];
				[currentDir release];
				currentDir = [absolutePathToParent retain];
				[self refreshFolderList];
			}
		}
	}
	
	//Return Key
	if ([key isEqual:SMPReturnKey]) {
		if (selectedTab == 0) {
			if (inLeft) {
				currentItem=0;
				NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
				[self playSongWithPath:[theArray objectAtIndex:currentItem]];
				[rightData refreshSubList];

			} else {
				NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
				[self playSongWithPath:[theArray objectAtIndex:currentItem]];
			}
		}
		if (selectedTab == 2) {
			BOOL isDir;
			NSString *absolutePathToSelection = [NSString stringWithFormat:@"%@/%@", defaultPath,[filesSubList objectAtIndex:[filesView selectedRow]]];
			if ([[NSFileManager defaultManager] fileExistsAtPath:absolutePathToSelection isDirectory:&isDir]) {
				if (isDir) {
					[self addFolderToPlaylist:absolutePathToSelection];
				} else {
					[self addFileToPlaylist:absolutePathToSelection];
				}
			}
		} else if (selectedTab == 1) {
			BOOL isDir;
			NSString *absolutePathToSelection = [NSString stringWithFormat:@"%@/%@", currentDir,[filesSubList objectAtIndex:[foldersView selectedRow]]];
			if ([[NSFileManager defaultManager] fileExistsAtPath:absolutePathToSelection isDirectory:&isDir]) {
				if (isDir) {
					[self addFolderToPlaylist:absolutePathToSelection];
				} else {
					[self addFileToPlaylist:absolutePathToSelection];
				}
			}
		} 
		
	}


		if ([key isEqual:SMPEnterKey]){
			if (selectedTab == 1){
				BOOL isDir;
				NSString *absolutePathToSelection = [NSString stringWithFormat:@"%@/%@", currentDir,[filesSubList objectAtIndex:[foldersView selectedRow]]];
				NSMutableArray *subFoldersList = [[[NSFileManager defaultManager] directoryContentsAtPath:absolutePathToSelection] retain]; 
				[subFoldersList removeObject:@".DS_Store"];
				NSEnumerator *enumerator = [subFoldersList objectEnumerator];
				id object;
				while (object = [enumerator nextObject]){
					NSString *absolutePathToObject =[NSString stringWithFormat:@"%@/%@", absolutePathToSelection, object];
					NSLog(absolutePathToObject);
					if ([[NSFileManager defaultManager] fileExistsAtPath:absolutePathToObject isDirectory:&isDir]) {
						if (isDir) {
							[self addFolderToPlaylist:absolutePathToObject];
						} else {
							[self addFileToPlaylist:absolutePathToObject];
						}
					}
				}
			} else if (selectedTab == 2) {
				[self addSearchListToPlaylist];
			}
		}
	
	
	//DeleteKey
	if ([key isEqual:SMPDeleteKey]) {
		if (selectedTab==0){
			if (inLeft) {
				[playlist removeObjectAtIndex:currentPlaylistFolder];
				[leftData refreshSubList];
				[rightData refreshSubList];
			} else {
				NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
				[theArray removeObjectAtIndex:currentItem];
				if ([theArray count] <1) {	
					[playlist removeObjectAtIndex:currentPlaylistFolder];
					[leftData refreshSubList];
				}
				[rightData refreshSubList];
			}
		}
	}
	
	
	//Apostrophe
	if ([key isEqual:@"\'"]) {
		if (selectedTab == 2) {
			BOOL isDir;
			NSString *absolutePathToSelection = [NSString stringWithFormat:@"%@/%@", defaultPath,[filesSubList objectAtIndex:[filesView selectedRow]]];
			if ([[NSFileManager defaultManager] fileExistsAtPath:absolutePathToSelection isDirectory:&isDir]) {
				if (isDir) {
					[self addFolderToPlaylist:absolutePathToSelection];
				} else {
					[self addFileToPlaylist:absolutePathToSelection];
				}
				currentPlaylistFolder = [playlist count]-1;
				currentItem=0;
				[self stopSong];
				NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
				[self playSongWithPath:[theArray objectAtIndex:currentItem]];
			}
		} else if (selectedTab == 1) {
			BOOL isDir;
			NSString *absolutePathToSelection = [NSString stringWithFormat:@"%@/%@", currentDir,[filesSubList objectAtIndex:[foldersView selectedRow]]];
			if ([[NSFileManager defaultManager] fileExistsAtPath:absolutePathToSelection isDirectory:&isDir]) {
				if (isDir) {
					[self addFolderToPlaylist:absolutePathToSelection];
				} else {
					[self addFileToPlaylist:absolutePathToSelection];
				}
				currentPlaylistFolder = [playlist count]-1;
				currentItem=0;
				[self stopSong];
				NSMutableArray *theArray = [[playlist objectAtIndex:currentPlaylistFolder] filelist];
				[self playSongWithPath:[theArray objectAtIndex:currentItem]];
			}
		} 
		
	}
	
}

-(void)addFileToPlaylist:(NSString *)path
{
	NSLog(path);
	[playlist addObject:[PlaylistEntry makeWithFileNamed:path]];
	[leftData refreshSubList];
	[rightData refreshSubList];
}
-(void)addFolderToPlaylist:(NSString *)path
{
	NSLog(path);
	[playlist addObject:[PlaylistEntry makeWithFolderNamed:path]];
	[leftData refreshSubList];
	[rightData refreshSubList];
}

-(void)addSearchListToPlaylist
{
	searchString = [searchText stringValue];	
	NSLog(searchString);
	[playlist addObject:[PlaylistEntry makeWithName:searchString topLevel:defaultPath andFiles:filesList]];
	[leftData refreshSubList];
	[rightData refreshSubList];
}

-(NSMutableArray *)playlist
{
	return playlist;
}

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	if (selectedTab > 0) {
		return [filesSubList count];
	} else 

	return 0;
}

- (id)tableView:(NSTableView *)aTableView 
	objectValueForTableColumn:(NSTableColumn *)aTableColumn
	row:(int)rowIndex
{
	if (selectedTab > 0) {
		return [filesSubList objectAtIndex:rowIndex];
	}
	
	return nil;
}

-(NSMutableArray *)grep:(NSString *)aString inArray:(NSArray *)anArray
{
	NSMutableArray *outputArray = [[NSMutableArray alloc] init];
	NSEnumerator *enumerator = [anArray objectEnumerator];
	NSString *string;
	while (string = [enumerator nextObject]) {
		NSRange theRange=[[string lowercaseString] rangeOfString:[aString lowercaseString]];
		if (theRange.length == [aString length]) 
			[outputArray addObject:string];
	}
	return outputArray;
}
-(id)window
{
	return window;
}
@end
