/* SMPController */

#import <Cocoa/Cocoa.h>
#import <QTKit/QTKit.h>
#import "PlaylistEntry.h"

extern NSString *SMPDownKey;
extern NSString *SMPUpKey;
extern NSString *SMPLeftKey;
extern NSString *SMPRightKey;
extern NSString *SMPReturnKey;
extern NSString *SMPEnterKey;
extern NSString *SMPDeleteKey;

@interface SMPController : NSResponder
{
	NSString *defaultPath;
	NSString *currentDir;
	IBOutlet id playlistViewLeft;
	IBOutlet id playlistViewRight;
	IBOutlet id foldersView;
	IBOutlet id filesView;
	IBOutlet id window;
	IBOutlet id tabView;
	IBOutlet id leftData;
	IBOutlet id rightData;
	IBOutlet id volumeText;
	IBOutlet id modeText;
	IBOutlet id searchText;
	IBOutlet id helpDrawer;
	IBOutlet id helpView;
	int selectedTab;
	NSMutableArray *playlist;
	NSMutableArray *foldersList;
	NSMutableArray *filesList;
	NSArray *filesSubList;
	NSArray *folderSubList;
	int currentItem;
	int currentItem1;
	int currentItem2;
	int currentPlaylistFolder;
	BOOL inLeft;
	NSMovie *song;
	NSMovieView *player;
	NSTimer *statusTimer;
	NSTimeInterval remainingTime;
	BOOL isPaused;
	BOOL isPlaying;
	BOOL typing;
	float volume;
	int playMode;
	NSArray *modeArray;
	NSString *searchString;
}
- (IBAction)list:(id)sender;
-(NSString*)keyNameFromChar:(unichar)theChar;
-(void)handleKey:(NSString *)key;
-(void)refreshFolderList;
-(void)refreshFileList;
-(void)refreshFolderSubList;
-(void)refreshFileSubList;
- (int)numberOfRowsInTableView:(NSTableView *)aTableView;
- (id)tableView:(NSTableView *)aTableView 
	objectValueForTableColumn:(NSTableColumn *)aTableColumn
	row:(int)rowIndex;
-(void)addFileToPlaylist:(NSString *)path;
-(void)addFolderToPlaylist:(NSString *)path;
-(void)addSearchListToPlaylist;
-(NSMutableArray *)playlist;
-(int)currentPlaylistFolder;
-(int)currentItem;
-(void)setCurrentPlaylistFolder:(int)i;
-(void)setCurrentItem:(int)i;
-(void)playSongWithPath:(NSString *)path;
-(void)checkStatus:(NSTimer *)theTimer;
-(void)nextSong;
-(void)prevSong;
-(void)stopSong;
-(void)pauseSong;
-(void)continueSong;
-(NSMutableArray *)grep:(NSString *)aString inArray:(NSArray *)anArray;
-(void)typeKey:(NSString *)key;
-(void)jumpToSong:(int)j;
-(id)window;
@end
