#import "RightDataSource.h"
#import "PlaylistEntry.h";
#import "SMPController.h";

@implementation RightDataSource

-(void)refreshSubList
{
	int currentItem = [controller currentItem];
	int minItem = currentItem-7;
	int rangeSize = 15;
	NSArray *theArray = [[[controller playlist] objectAtIndex:[controller currentPlaylistFolder]] filelist];
	if (subList != nil)
		[subList release];
	if ((minItem + 15) > [theArray count]) minItem = [theArray count]-15;
	if (minItem < 1) minItem = 0; 
	if ((minItem + rangeSize) > [theArray count]) rangeSize = [theArray count] - minItem;
	if (currentItem < minItem) currentItem=minItem;
	if (currentItem >= (minItem + rangeSize)) currentItem = minItem + rangeSize-1; 
	subList = [[theArray subarrayWithRange:NSMakeRange(minItem, rangeSize)] retain];
	//NSLog(@"%d, %d, %d", minItem, rangeSize, currentItem);
	[controller setCurrentItem:currentItem];
	[playlistViewRight selectRowIndexes:[NSIndexSet indexSetWithIndex:currentItem-minItem] byExtendingSelection:NO];
	[playlistViewRight reloadData];
}

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	return [subList count];
}

- (id)tableView:(NSTableView *)aTableView 
	objectValueForTableColumn:(NSTableColumn *)aTableColumn
	row:(int)rowIndex
{
	NSString *theString =[subList objectAtIndex:rowIndex];
	NSArray *components = [theString pathComponents];
	return [components objectAtIndex:[components count]-1];

}
@end
