//
//  PlaylistEntry.m
//  SMP
//
//  Created by Yeolcoatl on 2/25/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import "PlaylistEntry.h"


@implementation PlaylistEntry

-(NSString *)name
{
	return name;
}
-(NSMutableArray *)filelist
{
	return filelist;
}
-(void)dealloc
{
	[name release];
	[filelist release];
	[super dealloc];
}
-(id)initWithFileNamed:(NSString *)path
{
	if (self = [super init]) {
		NSArray *components = [path pathComponents];
		name = [[components objectAtIndex:[components count]-1] retain];
		filelist = [[NSMutableArray alloc] init];
		[filelist addObject:path];
	}
	return self;
}
-(id)initWithFolderNamed:(NSString *)path
{
	if (self = [super init]) {
		BOOL isDir;
		NSArray *components = [path pathComponents];
		NSArray *foldersList = [[NSFileManager defaultManager] subpathsAtPath:path]; 
		NSEnumerator *enumerator = [foldersList objectEnumerator];
		id object;

		name = [[components objectAtIndex:[components count]-1] retain];
		filelist = [[NSMutableArray alloc] init];
		while (object = [enumerator nextObject]) {
			NSString *theString = [NSString stringWithFormat:@"%@/%@", path, object];
			if (([[NSFileManager defaultManager] fileExistsAtPath:theString isDirectory:&isDir]) && (!isDir)) {
				if ([[[theString pathExtension] lowercaseString] isEqual:@"mp3"])
					[filelist addObject:theString];
			}
		}
	}
	return self;
}
-(id)initWithName:(NSString *)n topLevel:(NSString *)path andFiles:(NSArray *)files{
	if (self = [super init]) {
		BOOL isDir;
		name = [n retain];
		filelist = [[NSMutableArray alloc] init];
		NSEnumerator *enumerator = [files objectEnumerator];
		id object;
		while (object = [enumerator nextObject]) {
			NSString *theString = [NSString stringWithFormat:@"%@/%@", path, object];
			if (([[NSFileManager defaultManager] fileExistsAtPath:theString isDirectory:&isDir]) && (!isDir)) {
				if ([[[theString pathExtension] lowercaseString] isEqual:@"mp3"])
					[filelist addObject:theString];
			}
		}
	}
	return self;
}

+(id)makeWithName:(NSString *)n topLevel:(NSString *)path andFiles:(NSArray *)files{
	return [[[PlaylistEntry alloc] initWithName:n topLevel:path andFiles:files] autorelease];
}
+(id)makeWithFileNamed:(NSString *)path
{
	return [[[PlaylistEntry alloc] initWithFileNamed:path] autorelease];
}
+(id)makeWithFolderNamed:(NSString *)path
{
	return [[[PlaylistEntry alloc] initWithFolderNamed:path] autorelease];
}

- (id)copyWithZone:(NSZone *)zone
{	
    return [self retain];
}

@end
