#import "LeftDataSource.h"
#import "PlaylistEntry.h"
#import "SMPController.h"

@implementation LeftDataSource

-(void)refreshSubList
{
	int currentItem = [controller currentPlaylistFolder];
	int minItem = currentItem-7;
	int rangeSize = 15;
	if (subList != nil)
		[subList release];
	if ((minItem + 15) > [[controller playlist] count]) minItem = [[controller playlist] count]-15;
	if (minItem < 1) minItem = 0; 
	if ((minItem + rangeSize) > [[controller playlist] count]) rangeSize = [[controller playlist] count] - minItem;
	if (currentItem < minItem) currentItem=minItem;
	if (currentItem >= (minItem + rangeSize)) currentItem = minItem + rangeSize-1; 
	subList = [[[controller playlist] subarrayWithRange:NSMakeRange(minItem, rangeSize)] retain];
	//NSLog(@"%d, %d, %d", minItem, rangeSize, currentItem);
	[controller setCurrentPlaylistFolder:currentItem];
	[playlistViewLeft selectRowIndexes:[NSIndexSet indexSetWithIndex:currentItem-minItem] byExtendingSelection:NO];
	[playlistViewLeft reloadData];
}

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	return [subList count];
}

- (id)tableView:(NSTableView *)aTableView 
	objectValueForTableColumn:(NSTableColumn *)aTableColumn
	row:(int)rowIndex
{
	return [[subList objectAtIndex:rowIndex] name];
}

@end
